% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bio3d.R
\name{m_fetch_pdb}
\alias{m_fetch_pdb}
\title{Fetch Structure from PDB}
\usage{
m_fetch_pdb(pdb, save.pdb = FALSE, path = NULL)
}
\arguments{
\item{pdb}{PDB ID string for structure.}

\item{save.pdb}{Logical, whether or not to save the PDB to local drive. Will
speed up subsequent load times. Defaults to \code{FALSE}}

\item{path}{If \code{save.pdb = TRUE}, determines the location for file to
be saved. Defaults to \code{getwd()}.}
}
\description{
Using specified pdb id, retrieved .pdb file using bio3d::get.pdb() function.
Will always query the only PDB for structure, and not store on local drive.
May take some time to fetch information, every time it is run.
}
\examples{
library(r3dmol)
\dontrun{
r3dmol() \%>\%
  m_add_model(data = m_fetch_pdb("1bna")) \%>\%
  m_set_style(style = c(m_style_cartoon(), m_style_stick())) \%>\%
  m_zoom_to()
}
}
