% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonpar_bs_ci.R
\name{nonpar_bs_ci}
\alias{nonpar_bs_ci}
\title{Non-Parametric bootstrapped confidence intervals to control RCC}
\usage{
nonpar_bs_ci(data, analysis.func, rank.func = NULL, level = 0.9,
  res.orig = NULL, n.rep = 1000, use.abs = TRUE, parallel = FALSE, ...)
}
\arguments{
\item{data}{An n by K matrix of data}

\item{analysis.func}{A function that performs the analysis. This function should take exactly one argument (data) and return a
list or data frame including an item called 'estimate' and an item called 'statistic'. 
These should both be vectors of length p, the number of parameters.}

\item{rank.func}{A function that takes, as first argument, the statistics returned by analysis.func.
The second argument should be use.abs which can take a logical value. This argument indicates
if ranking should be based on signed or absolute value of the statistics. rank.func should
return a list including items named order and rank. See rcc:::basic_rank for an example.
If NULL, the basic_rank function 
will be used which ranks based on the size of the
test statistics.}

\item{level}{Confidence level}

\item{res.orig}{Results of applying analysis.funct to the original data if they are already available.
If NULL, these will be calculated.}

\item{n.rep}{Number of bootstrap replications}

\item{use.abs}{Logical. Rank based on absolute value of the statistics}

\item{parallel}{Logical. If true, use the parallel package to make use of multiple cores.}

\item{...}{Additional parameters to pass to rank.func}
}
\value{
A data frame giving original estimates and statistics, 
confidence intervals, debiased point estimates, and rank for each parameter.
}
\description{
This function implements Algorithm 3 in the paper (see Section 2.4). 
The user supplies individual level data and an analysis function that generates
test statistics and point estimates. The function resamples individuals from the 
original data and recalculates test statistics and estimates 
in order to calculate confidence intervals.
}
\examples{
#Generate some data -- 10 parameters, 30 samples
#Most problems will have many more parameters!
set.seed(4e8)
dat <- matrix(rnorm(n=10*30), nrow=10)

#Write a function to do a t-test comparing
#the first 15 samples and the last 15 samples
my.analysis.func <- function(data){
    x <- rep(c(1, 0), each=15)
    B <- t(apply(data, MARGIN=1, FUN=function(y){
        f <- t.test(y~x)
        est <- f$estimate[2]-f$estimate[1]
        stat <- f$statistic
        return(c(est, stat))
    }))
    B <- data.frame(B)
    names(B) <- c("estimate", "statistic")
    return(B)
}

#Calculate confidence intervals
cis <- nonpar_bs_ci(data=dat, analysis.func=my.analysis.func, n.rep=500)
head(cis)
}
