% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e_step.r
\name{Estep}
\alias{Estep}
\title{Expectation step.}
\usage{
Estep(
  p,
  item_data,
  pred_data,
  item_type,
  mean_predictors,
  var_predictors,
  theta,
  samp_size,
  num_items,
  num_responses,
  adapt_quad,
  num_quad,
  get_eap,
  NA_cases
)
}
\arguments{
\item{p}{List of parameters.}

\item{item_data}{Matrix or dataframe of item responses.}

\item{pred_data}{Matrix or dataframe of DIF and/or impact predictors.}

\item{item_type}{Vector of character values indicating the item type.}

\item{mean_predictors}{Possibly different matrix of predictors for the mean
impact equation.}

\item{var_predictors}{Possibly different matrix of predictors for the
variance impact equation.}

\item{theta}{Vector of fixed quadrature points.}

\item{samp_size}{Sample size in dataset.}

\item{num_items}{Number of items in dataset.}

\item{num_responses}{Number of responses for each item.}

\item{adapt_quad}{Logical indicating whether to use adaptive quadrature.}

\item{num_quad}{Number of quadrature points used for approximating the
latent variable.}

\item{get_eap}{Logical indicating whether to compute EAP scores.}

\item{NA_cases}{Logical vector indicating missing observations.}
}
\value{
a \code{"list"} of posterior values from the expectation step
}
\description{
Expectation step.
}
\keyword{internal}
