% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_nuts.R
\name{recode_nuts}
\alias{recode_nuts}
\title{Recode Region Codes From Source To Target NUTS Typology}
\usage{
recode_nuts(dat, geo_var = "geo", nuts_year = 2016)
}
\arguments{
\item{dat}{A data frame with a 3-5 character \code{geo_var} variable
to be validated.}

\item{geo_var}{Defaults to \code{"geo"}. The variable that contains
the 3-5 character geo codes to be validated.}

\item{nuts_year}{The year of the NUTS typology to use.
You can select any valid
NUTS definition, i.e. \code{1999}, \code{2003}, \code{2006},
\code{2010}, \code{2013}, the currently used \code{2016} and the
already announced and defined \code{2021}. Defaults to the current
typology in force, which is \code{2016}.}
}
\value{
The original data frame with a \code{'geo_var'} column is extended
with a \code{'typology'} column that states in which typology is the \code{'geo_var'}
a valid code.  For invalid codes, looks up potential reasons of invalidity
and adds them to the \code{'typology_change'} column, and at last it
adds a column of character vector containing the desired codes in the
target typology, for example, in the NUTS2013 typology.
}
\description{
Validate your geo codes, pair them with the appropriate standard
typology, look up potential causes of invalidity in the EU correspondence
tables, and look up the appropriate geographical codes in the other
(target) typology.  For example, validate geo codes in the \code{'NUTS2016'}
typology and translate them to the now obsolete the \code{'NUTS2010'} typology
to join current data with historical data sets.
}
\examples{
{
foo <- data.frame (
  geo  =  c("FR", "DEE32", "UKI3" ,
            "HU12", "DED",
            "FRK"),
  values = runif(6, 0, 100 ),
  stringsAsFactors = FALSE )

recode_nuts(foo, nuts_year = 2013)
}
}
\seealso{
Other recode functions: 
\code{\link{get_country_code}()}
}
\concept{recode functions}
