% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_checkConditionW.R
\name{checkConditionW}
\alias{checkConditionW}
\title{Condition check for weak FWER control in RGA}
\usage{
checkConditionW(w, G)
}
\arguments{
\item{w}{a vector of initial weights}

\item{G}{a matrix of initial transaction weights}
}
\value{
a logical value indicating whether the RGA's conditions are satisfied or not for the weak FWER control
}
\description{
Check the sufficient condition in RGA for the weak FWER control.
}
\details{
The conditions verified here are sufficient conditions. If a logical value \code{TRUE} is returned, then the weak control of the FWER is guaranteed. The weak control of the FWER may still hold even if the output is \code{FALSE}.
}
\examples{
w <- c(0.31, 0.33, 0.36)
G <- matrix(c(0,0.4,0.6, 0.7,0,0.3, 0.5,0.5,0),nrow=3,byrow=TRUE)
checkConditionW(w=w,G=G)
w <- c(0.5,0.5,0)
G <- matrix(c(0,1,0, 0.25,0,0.75, 1,0,0), nrow=3, byrow=TRUE)
checkConditionW(w=w,G=G)
}
\author{
Jiangtao Gou

Fengqing Zhang
}
