% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http.R
\name{http}
\alias{http}
\alias{http_client}
\title{Make a HTTP request}
\usage{
http(req, method = "GET")

http_client(req)
}
\arguments{
\item{req}{A \code{req} class object}

\item{method}{(character) Pick which HTTP method to use. Only GET and
POST for now. Default: GET}
}
\description{
Make a HTTP request
}
\details{
By default, a GET request is made. Will fix this soon to easily allow
a different HTTP verb.

The \code{http} function makes the request and gives back the parsed result.
Whereas, the \code{http_client} function makes the request, but gives back
the raw R6 class object, which you can inspect all parts of, modify, etc.
}
\examples{
\dontrun{
# high level - http()
api('https://api.github.com/') \%>\%
  api_path(repos, ropensci, rgbif, commits) \%>\%
  http()

# low level - http_client()
res <- api('https://api.github.com/') \%>\%
  api_path(repos, ropensci, rgbif, commits) \%>\%
  http_client()
res$count()
res$body()
res$status()
res$result
res$links
res$parse()

# Specify HTTP verb
api("http://httpbin.org/post") \%>\%
   api_body(x = "A simple text string") \%>\%
   http("POST")
}
}

