% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public_candles.R
\name{public_candles}
\alias{public_candles}
\title{Get bids and asks for provided currency-pair (products) by GDAX.}
\usage{
public_candles(
  product_id = "BTC-USD",
  start = NULL,
  end = NULL,
  granularity = NULL
)
}
\arguments{
\item{product_id}{Optional character parameter. This is a case insensitive value of the product id for which the order book is desired. Default to \code{'LTC-USD'}. For all valid product ids, refer to \code{\link{public_info}}.}

\item{start}{Optional string parameter. Start time in ISO 8601. Format YYYY-MM-DD}

\item{end}{Optional string parameter. End time in ISO 8601. Format YYYY-MM-DD}

\item{granularity}{Optional parameter. Desired timeslice in seconds. The granularity field must be one of the following values: \code{60, 300, 900, 3600, 21600, 86400}. Otherwise, the request will be rejected. These values correspond to timeslices representing one minute, five minutes, fifteen minutes, one hour, six hours, and one day, respectively.}
}
\value{
Dataframe with a time of the candle, low, high, open , close and volume for that candle.
}
\description{
This function is a public function and will fetch historic rates for provided currency pair (product_id). Rates are returned in grouped buckets based on requested granularity. A maximum of 300 records are returned. If the date range and granularity are not within the resultant volume set, it will be rejected by Coinbase Pro.
}
\examples{
\dontrun{
public_candles()
public_candles("ETH-EUR")
ublic_candles("ETH-EUR",start="2012-01-18", end="2012-01-25",granularity=3600)
}

}
