% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R
\name{rockr.file_download}
\alias{rockr.file_download}
\title{Download a file}
\usage{
rockr.file_download(
  conn,
  source,
  destination = NULL,
  overwrite = FALSE,
  temp = FALSE
)
}
\arguments{
\item{conn}{A rockr connection object.}

\item{source}{Path to the file in the R server file system.}

\item{destination}{Path to the file to be written. If omitted, file with same name in the working directory will be written.
Any non-existing parent directories will be created.}

\item{overwrite}{Overwrite the destination file if TRUE. Default is FALSE.}

\item{temp}{Logical to specify whether the root folder is the R session's home or the temporary folder. Default is FALSE.}
}
\value{
Void
}
\description{
Download a file or a folder from the Rocker R session working directory.
}
\examples{
\dontrun{
conn <- rockr.connect(username='user', password='password',
                      url='https://rocker-demo.obiba.org')
rockr.open(conn)
# download a file
rockr.file_download(conn, 'data.csv')
# download, create destination folder and rename file
rockr.file_download(conn, 'DatabaseTest.sav', 'spss/test.sav')
rockr.close(conn)
}
}
\seealso{
Other file functions: 
\code{\link{rockr.file_upload}()}
}
\concept{file functions}
