% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_ticket_search.R
\name{rt_ticket_search}
\alias{rt_ticket_search}
\title{Search for tickets}
\usage{
rt_ticket_search(query, orderby = NULL, format = "l", fields = NULL, ...)
}
\arguments{
\item{query}{(character) Your query (See Details)}

\item{orderby}{(character) How to order your search results. Should be a
ticket property name preceded by either a + or a - character.}

\item{format}{(character) Either \code{i} (ticket ID only),
\code{s} (ticket ID and subject), or \code{l} (full ticket metadata).
Defaults to \code{l}.}

\item{fields}{(character) Comma-separated list of fields to include in the
results.}

\item{...}{Other arguments passed to \code{\link{rt_GET}}}
}
\value{
Either a \code{data.frame} or \code{tibble} (when format is \code{l} or \code{s}) or a
numeric vector when it's \code{i}.
}
\description{
Search RT for tickets using RT's query syntax which is documented at
\url{https://docs.bestpractical.com/rt/4.4.4/query_builder.html}.
}
\details{
The \code{query} parameter conforms to RT's
\href{https://docs.bestpractical.com/rt/4.4.4/query_builder.html}{query syntax}
and requires you to build the query yourself. A query will have one or more
parameters of the form \verb{$FIELD='$VALUE'} where \verb{$FIELD} is an RT ticket
property like Subject, Requestor, etc and \verb{$VALUE} (surrounded by single
quotes) is the value to filter by. See Examples for examples.
}
\examples{
\dontrun{
# To return all un-owned tickets on a queue:
rt_ticket_search("Queue='General' AND (Status='new')")

# We can sort by date created, increasing
rt_ticket_search("Queue='General' AND (Status='new')",
                 orderby = "+Created")

# If we just need a vector of ticket ids
rt_ticket_search("Queue='General' AND (Status='new')",
                 orderby = "+Created",
                 format = "i")
}
}
