% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRneg.R
\name{LRneg}
\alias{LRneg}
\title{Sample Size for Estimating LR negative of a Single Diagnostic Test}
\usage{
LRneg(se, sp, lrneg, alp, pwr, k = 1)
}
\arguments{
\item{se}{anticipated sensitivity of the diagnostic test}

\item{sp}{anticipated specificity of the diagnostic test}

\item{lrneg}{anticipated LR negative value}

\item{alp}{level of significance}

\item{pwr}{desired level of power}

\item{k}{number of control(s) per case}
}
\value{
a list object with minimum required sample size with reporting
}
\description{
Calculate sample size(cases) based on negative likelihood ratio an unified index for
comparing the accuracy of two diagnostic tests
}
\examples{
LRneg(se=0.9, sp=0.5,lrneg=0.4,alp=0.05, pwr=0.8,k=1)
}
\references{
Simel, D.L., Samsa, G.P. Matchar, D. B. (1991). Likelihood ratio with
confidence: sample size estimation for diagnostic test studies. J Clin Epidemiol. 44: 763-70.
}
\author{
R. Amala, Scientist-C, ICMR-VCRC, Puducherry  & G. Kumarapandiyan, Asst. Prof., Madras Christian College, Chennai
}
