% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.se.R
\name{est.se}
\alias{est.se}
\title{Sample size for estimating sensitivity}
\usage{
est.se(p, se, prec, alp)
}
\arguments{
\item{p}{Prevalence of disease}

\item{se}{anticipated sensitivity of the test}

\item{prec}{Precision required on either side of the true sensitivity}

\item{alp}{level of significance or accepted level of probability of type I error}
}
\value{
a list of total sample size based on sensitivity along with reporting
}
\description{
In diagnostic studies, the test yields a binary outcome and accuracy is evaluated by sensitivity
and specificity. This function calculates sample size for estimating sensitivity when the diagnostic
test yields a binary outcome.
}
\examples{
est.se(p = 0.10, se = 0.99, prec = 0.03, alp = 0.05)
}
\references{
Hajian-Tilaki, K. (2014). Sample size estimation in diagnostic test studies of biomedical informatics. Journal of biomedical informatics, 48, 193-204.
}
\author{
R. Amala, Scientist-C, ICMR-VCRC, Puducherry  & G. Kumarapandiyan, Asst. Prof., Madras Christian College, Chennai
}
