% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{segment.pconductance_range}
\alias{segment.pconductance_range}
\title{Calculate empirical P(Lower <= Conductance <= Upper) of a segment.}
\usage{
segment.pconductance_range(segment, lower = 0, upper = Inf)
}
\arguments{
\item{segment}{the segment object}

\item{lower}{lower bound on conductance (defaults to 0)}

\item{upper}{upper bound on conductance (defaults to infinity)}
}
\value{
The probability of being in these conductance states
}
\description{
Calculate empirical P(Lower <= Conductance <= Upper) of a segment.
}
\examples{

# It's more likely that you created states or dwells with some function
states  <-  c(0,    0.2,    0,    1,    0,  0.5,    0,  0.7,    0,    1)
dwells  <-  c(0.1,  1.1,  0.5,  0.2,  1.0,  1.1,  0.6,  1.1,  0.8,  1.1)
my_burst <- segment.create(states, dwells, seg=1, start_time=3.14159, name="example_segment")

segment.pconductance_range(my_burst, lower=0.5, upper=0.5)

}
