% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bursts.R
\name{bursts.check_subconductance}
\alias{bursts.check_subconductance}
\title{Check if segment contains subconductive states}
\usage{
bursts.check_subconductance(bursts)
}
\arguments{
\item{bursts}{The list of all bursts}
}
\value{
True if it contains an conductance other than 0 or 1, False otherwise.
}
\description{
Check if segment contains subconductive states
}
\examples{

infile <- system.file("extdata", "example4.dwt", package = "scbursts")
dwells <- dwt.read(infile)
dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")
bursts <- bursts.defined_by_tcrit(dwells_c, 100, units="ms")

bursts.check_subconductance(bursts)

}
