% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cplot.R
\name{cplot.conductance_hist}
\alias{cplot.conductance_hist}
\title{Histogram of Conductance States}
\usage{
cplot.conductance_hist(bursts, ...)
}
\arguments{
\item{bursts}{List of multiple segments}

\item{...}{other arguments passed to histogram}
}
\description{
Histogram of Conductance States
}
\examples{

infile <- system.file("extdata", "example4.dwt", package = "scbursts")
dwells <- dwt.read(infile)
dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")
bursts <- bursts.defined_by_tcrit(dwells_c, 100, units="ms")

cplot.conductance_hist(bursts, main="example4.dwt conductance state histogram")

}
