% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/action-query.R
\name{req_has_query}
\alias{req_has_query}
\title{Switch Scenes on Query}
\usage{
req_has_query(key, values = NULL, negate = FALSE)
}
\arguments{
\item{key}{The key that must be present, as a length-1 character vector.}

\item{values}{Details about what to look for in the \code{key}. \code{NULL} indicates
that the \code{key} must be present but its contents are unimportant for this
action. Otherwise the actual value of the query must be present in
\code{values}.}

\item{negate}{If \code{TRUE}, trigger the corresponding scene when this action is
\code{not} matched.}
}
\value{
A \code{scene_action} object, to be used in \code{\link[=set_scene]{set_scene()}}.
}
\description{
Create a \code{scene_action} specifying a key that must be present (or absent) in
the query string (the part of the URL when the shiny app was called, after
"?"), and optionally a value or values for that key. For example, in
\code{myapps.shinyapps.io/myapp?param1=1&param2=text}, \code{?param1=1&param2=text} is
the query string, \code{param1} and \code{param2} are keys, and \code{1} and \code{text} are
their corresponding values.
}
\examples{
# Specify an action to detect a "code" parameter in the query.
req_has_query("code")

# Specify an action to detect the *lack* of a "code" parameter in the query.
req_has_query("code", negate = TRUE)

# Specify an action to detect a "language" parameter, with values containing
# "en" or "es".
req_has_query("language", "en|es")
}
