% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{delta_optim_SCQE_2C}
\alias{delta_optim_SCQE_2C}
\title{Delta optimization method for \code{scqe} 2 cohort, summary statistics}
\usage{
delta_optim_SCQE_2C(
  delta,
  untr_pre,
  untr_post,
  tr_post,
  tr_pre,
  Y_tr_post,
  Y_untr_post,
  Y_tr_pre,
  Y_untr_pre,
  obj,
  specified = NULL,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{delta}{Single value or vector of possible values for change in
average non-treatment outcome between cohorts (if applicable).}

\item{untr_pre}{Integer number of untreated patients in the first cohort if
applicable (summary statistics input) (T=0).}

\item{untr_post}{Integer number of untreated patients in the second cohort
if applicable (summary statistics input) (T=1).}

\item{tr_post}{Integer number of treated patients in the second cohort if
applicable (summary statistics input) (T=1).}

\item{tr_pre}{Integer number of treated patients in the first cohort if
applicable (summary statistics input) (T=0).}

\item{Y_tr_post}{Outcome for patients who received treatment at time T=1
(summary statistics input).}

\item{Y_untr_post}{Outcome for patients who did not receive treatment at
time T=1 (summary statistics input).}

\item{Y_tr_pre}{Outcome for patients who did receive treatment at time T=0
(summary statistics input).}

\item{Y_untr_pre}{Outcome for patients who did not receive treatment at time
T=0 (summary statistics input).}

\item{obj}{scqe object.}

\item{specified}{Specified optional arguments.}

\item{alpha}{Numeric alpha for confidence intervals (default alpha = 0.05).}

\item{...}{Extra optional arguments.}
}
\value{
Optimal delta.
}
\description{
The \code{print} method provides the critical values presented in the summary
method for scqe objects.
}
