% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/silcTools2.R
\name{silcTools2}
\alias{silcTools2}
\alias{mergeSILC}
\alias{checkCol}
\alias{chooseSILCvars}
\alias{modifySILC}
\alias{loadSILC}
\title{Utility functions for EU-SILC data}
\usage{
loadSILC(
  file = NULL,
  filed = NULL,
  filer = NULL,
  filep = NULL,
  fileh = NULL,
  year = 2013,
  country = "Austria"
)

mergeSILC(filed, filer, fileh, filep)

checkCol(x, y)

chooseSILCvars(
  x,
  vars = c("db030", "db040", "rb030", "rb080", "rb090", "pl031", "pb220a", "py010g",
    "py021g", "py050g", "py080g", "py090g", "py100g", "py110g", "py120g", "py130g",
    "py140g", "hy040g", "hy050g", "hy060g", "hy070g", "hy080g", "hy090g", "hy100g",
    "hy110g", "hy120g", "hy130g", "hy140g", "db090", "rb050", "pb190", "pe040", "pl051",
    "pl111", "rb010"),
  country = NULL
)

modifySILC(x, country = "Austria")
}
\arguments{
\item{file}{data set in R binary format, csv or sav (SPSS) of merged EU-SILC data.}

\item{filed}{data set including the household register information}

\item{filer}{data set including the personal register information}

\item{filep}{data set including the personal information}

\item{fileh}{data set including the household information}

\item{year}{year of origin}

\item{country}{country}

\item{x}{public-use file (for checkCol function) or orginal data}

\item{y}{scientific-use file (for checkCol function)}

\item{vars}{variables to be selected for function chooseSILCvars}
}
\description{
Various utility functions mainly used for simulating EU-SILC data
}
\details{
Collection of functions to import, select and modify data EU-SILC data.
Either file (merged data) or single files have to be provided for loadSILC().
}
\examples{
\dontrun{
x <- loadSILC("new_workfile.RData")
filed <- "zielvar_d_eurostat2013.sav"
filer <- "zielvar_r_eurostat2013.sav"
filep <- "zielvar_p_eurostat2013.sav"
fileh <- "zielvar_h_eurostat2013.sav"
suf4 <- loadSILC(filed = filed,
                 filer = filer,
                 filep = filep,
                 fileh = fileh)
}
\dontrun{
filed <- "zielvar_d_eurostat2013.sav"
filer <- "zielvar_r_eurostat2013.sav"
filep <- "zielvar_p_eurostat2013.sav"
fileh <- "zielvar_h_eurostat2013.sav"
suf4 <- loadSILC(filed = filed,
                 filer = filer,
                 filep = filep,
                 fileh = fileh)
suf <- mergeSILC(d = suf4[["d"]],
                 r = suf4[["r"]],
                 h = suf4[["h"]],
                 p = suf4[["p"]])
}
data(eusilc13puf)
## instead of scientific-use file or
## original data we took the 2006 synthetic data
data(eusilcS)
## check which columns of y are in x
checkCol(eusilc13puf, eusilcS)
\dontrun{
## on original silc data to extract needed variables for SGA project on SILC
x <- loadSILC("new_workfile.RData")
chooseSILCvars(x)
}
\dontrun{
## wrapper to prepare SILC data
## on original silc data
x <- loadSILC("new_workfile.RData")
x <- chooseSILCvars(x)
modifySILC(x)
}
}
\author{
Matthias Templ
}
