% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms.R
\name{plot.ssr}
\alias{plot.ssr}
\title{Plots a ssr object}
\usage{
\method{plot}{ssr}(x, metric = "rmse", ptype = 1, ...)
}
\arguments{
\item{x}{a fitted object of class "ssr".}

\item{metric}{the type of metric to be plotted ("rmse", "mae", "cor"), defaults to "rmse". "cor" is for pearson correlation.}

\item{ptype}{an integer specifying the type of plot. The default 1, plots the performance metric of the fitted model.
Any value different of 1, plots the performance metric of the individual regressors used to build the model.}

\item{...}{additional arguments to be passed to the plot function.}
}
\value{
a NULL invisible object.
}
\description{
Plots the results of a fitted ssr object if a testset was provided when fitting the model.
}
\details{
This function generates performance plots to quickly inspect the results of the fitted model.
The fitted model contains all the necessary data so the user can create custom plots, if required.
}
\examples{
dataset <- friedman1 # Load dataset.

set.seed(1234)

# Prepare the data.
split1 <- split_train_test(dataset, pctTrain = 70)
split2 <- split_train_test(split1$trainset, pctTrain = 5)
L <- split2$trainset
U <- split2$testset[, -11]
testset <- split1$testset
regressors <- list(knn = caret::knnreg)
model <- ssr("Ytrue ~ .", L, U, regressors = regressors, testdata = testset, maxits = 10)

# Plot the RMSE of the fitted model.
plot(model, metric = "rmse", ptype = 1)

# Plot the MAE.
plot(model, metric = "mae", ptype = 1)
}
