% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_means.R
\name{spatial_means}
\alias{spatial_means}
\alias{spatial_means.data.frame}
\alias{spatial_means.stars}
\alias{autoplot.spatialmeans}
\title{Computes spatial empirical means using a dataframe or a stars object}
\usage{
spatial_means(x, ...)

\method{spatial_means}{data.frame}(x, lat_col, lon_col, t_col, z_col, ...)

\method{spatial_means}{stars}(x, ...)

\method{autoplot}{spatialmeans}(
  object,
  ylab = "Mean Value",
  xlab1 = "Latitude",
  xlab2 = "Longitude",
  title = "Spatial Empirical Means",
  ...
)
}
\arguments{
\item{x}{A stars object or a dataframe. Arguments differ according to the input type.}

\item{...}{Other arguments currently ignored.}

\item{lat_col}{For dataframes: the column or the column name giving the latitude. The y coordinate can be used instead of latitude.}

\item{lon_col}{For dataframes: the column or the column name giving the longitude. The x coordinate can be used instead of longitude.}

\item{t_col}{For dataframes: the time column. Time must be a set of discrete integer values.}

\item{z_col}{For dataframes: the The quantity of interest that will be plotted. Eg. temperature.}

\item{object}{For autoplot: the output from the `spatial_means' function.}

\item{ylab}{For autoplot: the ylabel.}

\item{xlab1}{For autoplot: The xlabel for the first plot.}

\item{xlab2}{For autuoplot: The xlabel for the second plot.}

\item{title}{The graph title.}
}
\value{
A spatialmeans object contaiing spatial averages and the original data.
}
\description{
This function computes spatial empirical means by latitude and longitude averaged over time.
This function can take either a stars object or a dataframe. Input arguments differ for each case.
The autoplot function can plot this object.

The variations are
 * 'spatial_means.data.frame()' if the input is a dataframe
 * 'spatial_means.stars()' if the input is a stars object
 * 'autoplot.spatialmeans()' to plot the outputs.
}
\examples{
# dataframe example
data(NOAA_df_1990)
library(dplyr)
Tmax <- filter(NOAA_df_1990,                      # subset the data
              proc == "Tmax" &                   # extract max temperature
                month \%in\% 5:9 &                 # May to July
                year == 1993)                    # year 1993
Tmax$t <- Tmax$julian - min(Tmax$julian) + 1      # create a new time variable starting at 1
sp_df <- spatial_means(Tmax,
       lat_col = "lat",
       lon_col = "lon",
       t_col = "t",
       z_col = "z")
autoplot(sp_df)

# stars examples
library(stars)
tif = system.file("tif/olinda_dem_utm25s.tif", package = "stars")
x <- read_stars(tif)
sp_means <- spatial_means(x)
autoplot(sp_means)

}
