% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svTaskCallbackManager.R
\name{svTaskCallbackManager}
\alias{svTaskCallbackManager}
\title{Create task callbacks that are evaluated both from R and socket/http server}
\usage{
svTaskCallbackManager(handlers = list(), registered = FALSE, verbose = FALSE)
}
\arguments{
\item{handlers}{this can be a list of callbacks in which each element is a
list with an element named \code{f} which is a callback function, and an optional
element named \code{data} which is the 5-th argument to be supplied to the
callback when it is invoked. Typically this argument is not specified, and
one uses add to register callbacks after the manager is created.}

\item{registered}{a logical value indicating whether the \code{evaluate}
function has already been registered with the internal task callback
mechanism. This is usually \code{FALSE} and the first time a callback is
added via the add function, the evaluate function is automatically
registered. One can control when the function is registered by specifying
\code{TRUE} for this argument and calling \code{addTaskCallback()} manually.}

\item{verbose}{a logical value, which if \code{TRUE}, causes information to be
printed to the console about certain activities this dispatch manager
performs. This is useful for debugging callbacks and the handler itself.}
}
\value{
See \code{?taskCallbackManager} for both the returned object and how to use it.
}
\description{
\code{svTaskCallbackManager()} is a copy of \code{taskCallbackManager()} in R base
package, as of version 4.0.5 of R. Two important differences: (1) the top
task created is named \code{SV-taskCallbackManager} instead of
\code{R-taskCallbackManager}, and its tasks are executed after each top-level task
in R console, or after execution of non-hidden R code from the socket or http
server (take care: only once per set of code, no matter the number of
top-level task in the R code send by the client in the second case). All
taskCallbacks defined by \code{addTaskCallback()} or \code{taskCallbackManager$add()}
from R base package are not executed when code is invoked from the R socket
or http server!
}
\examples{
# create a task callback manager
cbman <- svTaskCallbackManager()
# Add a function to activate after each code evaluation in R
cbman$add(function(expr, value, ok, visible) {
  cat("Hi from the callback manager!\n")
  return(TRUE)
  }, name = "exampleHandler")
# Just issue a command and see the callback function activated
1 + 1
# List defined callbacks
cbman$callbacks()
# Remove the callback we just defined
cbman$remove("exampleHandler")
1 + 1
# Remove the task callback manager (base R function)
removeTaskCallback("SV-taskCallbackManager")
}
\seealso{
\code{\link[=taskCallbackManager]{taskCallbackManager()}}
}
\author{
Slightly modified from the original R core team's function by Ph.
Grosjean \href{mailto:phgrosjean@sciviews.org}{phgrosjean@sciviews.org}
}
\concept{task callback}
\keyword{IO}
