% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syschange.R
\name{syschange}
\alias{syschange}
\alias{rp}
\alias{rpse}
\alias{rc}
\alias{rcse}
\title{Systematic Change}
\usage{
rp(t)

rpse(t)

rc(t)

rcse(t)
}
\arguments{
\item{t}{The contingency table for Svensson's method, a two-dimension matrix.}
}
\value{
\code{rp} and \code{rc} give the RP and RC value. \code{rpse} and \code{rcse}
give the standard error of RP and RC.
}
\description{
The value and the standard error of relative position (RP), the systematic change in
position between the two ordered categorical classification.
Also, the value and the standard error of relative concentration (RC), a comprehensive
evaluation of the systematic change.
}
\examples{
x <- c (1:5,5:1)
y <- c(1:5,1,1,5,4,1)
z <- con_ta(x,y,)
rp(z)
rpse(z)
rc(z)
rcse(z)
}
\seealso{
\code{\link{con_ta}} for generating contingency table. \code{\link{indichange}}
for individual change. \code{\link{sresult}} for summary of Svensson's method analysis.
}
