% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeLineGraphics.R
\name{timeLineGraphics}
\alias{timeLineGraphics}
\title{timeLineGraphics}
\usage{
timeLineGraphics(
  l,
  vfactor = 3,
  abline = TRUE,
  bkgRBG = c(13, 65, 130),
  ablineRBG = c(26, 85, 145),
  pdfWidth = 20,
  pdfHeight = 20,
  extendRight = 50,
  yearsTicks = 10,
  ymargin = 0.05,
  nameCEX = 4,
  main = "Timelines",
  WidthHTML = 850,
  imageDir = tempdir(),
  leftOver = TRUE
)
}
\arguments{
\item{l}{is a list
\itemize{
\item character string $name the person's name
\item integer $start starting year
\item integer $end ending year
\item character string $color background color for the horizontal line
\item list of overlay pictures $pics, each entry contains
\itemize{
\item character string path name for a picture
\item integer year for placement of left edge of picture
}
}}

\item{vfactor}{is height of a horizontal strip}

\item{abline}{is Boolean if TRUE add dates and corresponding vertical ablines}

\item{bkgRBG}{is ie c(13,65,130) specifying background color}

\item{ablineRBG}{specifying abline color}

\item{pdfWidth}{the width parameter to pdf()}

\item{pdfHeight}{the height parameter to pdf()}

\item{extendRight}{extends plot to the right to provide room to fit in names}

\item{yearsTicks}{number of years interval between x axis ticks}

\item{ymargin}{is fraction of maxy to leave as top and bottom margin}

\item{nameCEX}{control size of font in text() to display names associated with each horizontal strip}

\item{main}{main title for the graph}

\item{WidthHTML}{the width of the figure when imported into html page}

\item{imageDir}{where to save the image output files}

\item{leftOver}{if TRUE then pictures that do not fit in horizontal strip are placed to left of strip rather than omitted}
}
\value{
{No return value, called for side effects}
}
\description{
This function is the driver that organizes the production of an html page
containing horizontal strips that symbolize events in a person's life.
}
\details{
the parameters here work fine in general
but they were tuned to match the chart in https://mathigon.org/timeline
since my intention is to generate a consistent display of that chart and my chart above one another
a consideration is to have the horizontal strips sufficiently tall
so that the images of the in-laid paintings can be seen clearly
the default RBG values match the design in https://mathigon.org/timeline
construct graph whose
x axis is years
y axis is items to be plotted such as a person's years of  birth and death
within a broad colored horizontal line
overlain with pictures related to that person
}
