% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tls.R
\name{tls}
\alias{tls}
\title{Fitting error-in-variables models via total least squares.}
\usage{
tls(formula, data, method = c("normal", "bootstrap"), conf.level = 0.95,
  ...)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be
coerced to that class): a symbolic description of the model to
be fitted.}

\item{data}{an optional data frame, list or environment (or object
coercible by as.data.frame to a data frame) containing the
variables in the model.}

\item{method}{method for computing confidence interval}

\item{conf.level}{the confidence level for confidence interval.}

\item{...}{Optional arguments for future usage.}
}
\value{
\code{tls} returns parameters of the fitted model including
    estimations of coefficient, corresponding estimated standard errors
    and confidence intervals.
}
\description{
It can be used to carry out regression models that account for
measurement errors in the independent variables.
}
\details{
This function should be used with care. Confidence interval estimation
is given by normal approximation or bootstrap. The normal approximation and
bootstrap are proper when all the error terms are independent from normal
distribution with zero mean and equal variance (see the references for
more details).
}
\examples{
library(tls)
set.seed(100)
X.1 <- sqrt(1:100)
X.tilde.1 <- rnorm(100) + X.1
X.2 <- sample(X.1, size = length(X.1), replace = FALSE)
X.tilde.2 <- rnorm(100) + X.2
Y <- rnorm(100) + X.1 + X.2
data <- data.frame(Y = Y, X.1 = X.tilde.1, X.2 = X.tilde.2)
tls(Y ~ X.1 + X.2 - 1, data = data)
}
\references{
\itemize{
\item  Gleser, Estimation in a Multivariate "Errors in Variables"
Regression Model: Large Sample Results, 1981, Ann. Stat.
\item Golub and Laon, An Analysis of the Total Least Squares Problem,
1980, SIAM J. Numer. Anal.
\item Pesta, Total least squares and bootstrapping with
applications in calibration, 2012, Statistics.}
}
\author{
Yan Li
}
