% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeData.R
\name{normalizeData}
\alias{normalizeData}
\title{Normalize audio data using Box-Cox transformation}
\usage{
normalizeData(
  audioData,
  measures = c("duration", "voice_breaks_percent", "RMS_env", "mean_loudness", "mean_F0",
    "sd_F0", "mean_entropy", "mean_HNR"),
  includeDimensions = FALSE,
  includeConditions = FALSE
)
}
\arguments{
\item{audioData}{A data.frame generated by the autoExtract() function.}

\item{measures}{A vector of strings specifying the measures to be normalized. Default corresponds to all the measures extracted by autoExtract().}

\item{includeDimensions}{A logical value indicating whether or not to include dimensions in the normalization process. Default corresponds to FALSE.}

\item{includeConditions}{A logical value indicating whether or not to include conditions in the normalization process. Default corresponds to FALSE.}
}
\value{
A list containing three elements: (1) a data frame of the normalized audio data and (2) a logical vector indicating whether or not each measure was transformed using Box-Cox transformation and (3) the Box-cox constant added to each measure.
}
\description{
This function normalizes audio data using the Box-Cox transformation. It takes in a data frame of audio data and a vector of measures to be normalized. Users can choose to normalize by dimensions and/or conditions.
}
\examples{
normalizeData(testAudioData)

}
