% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_GutsPnL.R
\name{gutsPnL}
\alias{gutsPnL}
\title{Calculates per share Profit and Loss (PnL) at expiration for Guts Option Strategy and draws its Bar Plot displaying PnL in the Plots tab.}
\usage{
gutsPnL(
  ST,
  X2HP,
  X1LC,
  P,
  C,
  hl = 0,
  hu = 2,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X2HP}{Higher Strike Price or eXercise price bought Put.}

\item{X1LC}{Lower Strike Price or eXercise price bought Call.}

\item{P}{Put Premium or Put Price paid for the bought put.}

\item{C}{Call Premium or Call Price paid for the bought Call.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss}

\item{myData}{Data frame}

\item{myTibble}{tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
This is a volatility strategy consisting of a long position in an ITM (in the money call : ST is greater than call strike price of X1LC ) call option with a strike price X1LC, and a long position in an ITM (in the money put : ST is less than put strike of X2HP) put option with a strike price X2HP. This is a net debit trade. Since both call and put options are ITM, this strategy is more costly to establish than a long straddle position. The trader or investor has neutral outlook. This is a capital gain strategy (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Guts Option Strategy and draw its graph in the Plots tab.
}
\examples{
gutsPnL(25,27,24.75,2.5,3)
gutsPnL(46,48,44,2,4,hl=0.6,hu=1.6)
gutsPnL(1020,1025,1015,10,18,hl=0.95,hu=1.045)
}
