% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_aStranglePnL.R
\name{aStranglePnL}
\alias{aStranglePnL}
\title{Calculates per share Profit and Loss (PnL) at expiration for Strangle Option Strategy and draws its Bar Plot displaying PnL in the Plots tab.}
\usage{
aStranglePnL(
  ST,
  X1LP,
  X2HC,
  C,
  P,
  hl = 0,
  hu = 2.2,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X1LP}{Lower Strike Price or eXercise price bought Put.}

\item{X2HC}{Higher Strike Price or eXercise price bought Call.}

\item{C}{Call Premium or Call Price paid for the bought Call.}

\item{P}{Put Premium or Put Price paid for the bought put.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss}

\item{myData}{Data frame}

\item{myTibble}{tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
This is a volatility strategy consisting of a long position in an OTM (out of the money) call option with a strike price K1, and a long position in an OTM (out of the money) put option with a strike price K2. This is a net debit trade. However, because both call and put options are OTM (out of the money), this strategy is less costly to establish than a long straddle position. The flip side is that the movement in the stock price required to reach one of the break-even points is also more significant. The outlook of trader or investor is neutral. This is a capital gain strategy (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Strangle Option Strategy and draw its graph in the Plots tab.
}
\examples{
aStranglePnL(25,22.50,27.50,0.85,1.40)
aStranglePnL(46,44,52,2,4,hl=0.6,hu=1.6)
aStranglePnL(1020,1015,1025,10,18,hl=0.95,hu=1.045)
}
