% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cache_or_create.R
\name{get_cache_or_create}
\alias{get_cache_or_create}
\title{Checks if variable exists in environment and returns back or creates a new variable}
\usage{
get_cache_or_create(
  var,
  func,
  ...,
  exists_func_args = NA,
  get_func_args = NA,
  warning_msg = NA_character_
)
}
\arguments{
\item{var}{character.  The name of the variable to check in the global environment.}

\item{func}{function.  A function that returns a value.}

\item{...}{Additional arguments to be passed to the param func.}

\item{exists_func_args}{list.  A list of arguments to use in base::exists.}

\item{get_func_args}{list.  A list of arguments to use in bass::get.}

\item{warning_msg}{character.  Message sent to stop function if an error occurs.}
}
\value{
Unknown.  The return type from the param func or the existing variable in global environment.
}
\description{
Checks if variable exists in environment and returns back or creates a new variable
}
\examples{
\dontrun{
df <- data.frame(col_1 = c("a","b","c"), col_2 = c(1,2,3))

create_blank_df <- function() {

    data.frame(col_1 = NA_character_, col_2 = NA_integer_)

    }

df_1 <- get_cache_or_create(
                          "df",
                          create_blank_df
                          )

df_2 <- get_cache_or_create(
                          "df_2",
                          create_blank_df
                          )
}
}
