% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grnn.fit.R
\name{grnn.fit}
\alias{grnn.fit}
\title{Create a general regression neural network}
\usage{
grnn.fit(x, y, sigma = 1, w = rep(1, length(y)))
}
\arguments{
\item{x}{The matrix of predictors}

\item{y}{The vector of response variable}

\item{sigma}{The scalar of smoothing parameter}

\item{w}{The vector of weights with default = 1 for each record}
}
\value{
A general regression neural network object
}
\description{
The function \code{grnn.fit} creates a general regression neural network (GRNN)
}
\examples{
data(iris, package = "datasets")
Y <- ifelse(iris[, 5] == "setosa", 1, 0)
X <- scale(iris[, 1:4])
gnet <- grnn.fit(x = X, y = Y)
}
\references{
Donald Specht. (1991). A General Regression Neural Network.
}
