% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importZoomRosetta.R
\name{importZoomRosetta}
\alias{importZoomRosetta}
\title{Helper function to add unique identifiers to processed Zoom downloads}
\usage{
importZoomRosetta(zoomOutput, zoomRosetta, meetingId)
}
\arguments{
\item{zoomOutput}{the output of batchProcessZoomOutput}

\item{zoomRosetta}{the path to an edited zoomRosetta xlsx}

\item{meetingId}{the name of the meetingId you want to use}
}
\value{
returns zoomOutput with identifiers in zoomRosetta
merged to any available data.frames in the zoomOutput file
}
\description{
Import an edited zoomRosetta file that tells how to
link up Zoom display names to some unique individual
identifier
}
\examples{
batchOutIds = importZoomRosetta(zoomOutput=
batchProcessZoomOutput(batchInput=system.file('extdata', 
'myMeetingsBatch.xlsx', package = 'zoomGroupStats')), 
zoomRosetta=system.file('extdata', 
'myMeetingsBatch_rosetta_edited.xlsx', package = 'zoomGroupStats'), 
meetingId="batchMeetingId")

\dontrun{
batchOutIds = importZoomRosetta(zoomOutput=batchOut, zoomRosetta="myEditedRosetta.xlsx", 
meetingId="batchMeetingId")
}
}
