% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windowedTextConversationAnalysis.R
\name{windowedTextConversationAnalysis}
\alias{windowedTextConversationAnalysis}
\title{Run a windowed analysis on either a Zoom transcript or chat
This function conducts a temporal window analysis on the conversation in
either a Zoom transcript or chat. It replicates the textConversationAnalysis
function across a set of windows at a window size specified by the user.}
\usage{
windowedTextConversationAnalysis(
  inputData,
  inputType,
  meetingId,
  speakerId,
  sentMethod = "none",
  timeVar = "automatic",
  windowSize
)
}
\arguments{
\item{inputData}{data.frame output of either processZoomTranscript or processZoomChat}

\item{inputType}{string of either 'chat' or 'transcript'}

\item{meetingId}{string giving the column with the meeting identifier}

\item{speakerId}{string giving the name of the identifier for the individual who made this contribution}

\item{sentMethod}{string giving the type of sentiment analysis to include, either 'aws' or 'syuzhet'}

\item{timeVar}{name of variable giving the time marker to be used.
For transcript, either use 'utteranceStartSeconds' or 'utteranceEndSeconds';
for chat use 'messageTime'}

\item{windowSize}{integer value of the duration of the window in number of seconds}
}
\value{
list with two data.frames. In the first (windowlevel), each row is a temporal window.
In the second (speakerlevel), each row is a user's metrics within a given temporal window.
}
\description{
Run a windowed analysis on either a Zoom transcript or chat
This function conducts a temporal window analysis on the conversation in
either a Zoom transcript or chat. It replicates the textConversationAnalysis
function across a set of windows at a window size specified by the user.
}
\examples{
win.text.out = windowedTextConversationAnalysis(inputData=sample_transcript_sentiment_aws, 
inputType="transcript", meetingId="batchMeetingId", speakerId="userName", sentMethod="aws", 
timeVar="utteranceStartSeconds", windowSize=600)
}
