#***********************************************************************************************************************************************
#*  
#*  (C) 2009     Andrzej Bk     Uniwersytet Ekonomiczny we Wrocawiu
#*  
#*  Funkcja do ksiki:
#*  "Statystyczna analiza danych z wykorzystaniem programu R", PWN, Warszawa 2009.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

# BTL(Usym, S, r) - funkcja obliczajca udziay w rynku profilw symulacyjnych na podstawie modelu BTL
# Usym - macierz uytecznoci cakowitych profilw symulacyjnych w przekroju respondentw
# S - liczba respondentw
# r - liczba profilw symulacyjnych
# wywoanie - Pbtl <- BTL(Usym, S, r)

BTL <- function(Usym, S, r)
{
   share <- matrix(0, r, S)   #macierz udziaw
   Pbtl <- vector("numeric", r)
   for(s in 1:S) {share[,s] <- Usym[,s]/sum(Usym[,s])}
   for(i in 1:r) {Pbtl[i] <- mean(share[i,])*100}
   return(Pbtl)
}