#***********************************************************************************************************************************************
#*  
#*  (C) 2009     Andrzej Bk     Uniwersytet Ekonomiczny we Wrocawiu
#*  
#*  Przykad do ksiki:
#*  "Statystyczna analiza danych z wykorzystaniem programu R", PWN, Warszawa 2009.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

source("matexpand.r")
source("utilities.r")
source("importance.r")
#kodowanie quasi-eksperymentalne atrybutw
options(contrasts=c("contr.sum","contr.poly"))
options(OutDec=",")
x <- read.csv2("Dane_10_1a.csv", header=TRUE)   #profile
y <- read.csv2("Dane_10_1c.csv", header=TRUE)   #preferencje empiryczne 
m <- length(x)     #liczba atrybutw
n <- nrow(x)       #liczba profilw
S <- nrow(y)/n     #liczba respondentw
xnms <- names(x)   #nazwy zmiennych objaniajcych (atrybuty)
ynms <- names(y)   #nazwa zmiennej objanianej (preferencje)
xtmp <- paste("factor(x$", xnms, sep="", paste(")"))
xfrm <- paste(xtmp, collapse="+")
yfrm <- paste("y$", ynms, sep="", "~")
frml <- as.formula(paste(yfrm, xfrm))      #model
Lj <- vector("numeric", m)                 #liczba poziomw j-tego atrybutu
for(j in 1:m) {Lj[j] <- nlevels(factor(x[[xnms[j]]]))}
x <- as.data.frame(matexpand(m, n, S, x))  #data frame
camodel <- lm(frml)
wyniki <- summary.lm(camodel)
u <- as.matrix(camodel$coeff)              #uytecznoci czstkowe poziomw atrybutw
ul <- utilities (u, Lj)
print ("Wszystkie uytecznoci czstkowe", quote=FALSE)
print(ul)
imp <- round(importance(ul, Lj)*100, 2)
print ("Wano atrybutw", quote=FALSE)
print(imp)
print(paste("Suma: ", sum(imp)), quote=FALSE)
# wykres wanoci atrybutw
nazwy <- names(x)
print("Wykres wanoci atrybutw", quote=FALSE)
barplot(imp, ylim=c(0,100), ylab="Wano atrybutu w %", xlab="Atrybuty", names.arg=nazwy)