% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam_addTraitADG}
\alias{SimParam_addTraitADG}
\title{Add an additive and dominance GxE trait}
\arguments{
\item{nQtlPerChr}{number of QTLs per chromosome. Can be a single 
value or nChr values.}

\item{mean}{a vector of desired mean genetic values for one or more traits}

\item{var}{a vector of desired genetic variances for one or more traits}

\item{varGxE}{a vector of total genotype-by-environment variances for the traits}

\item{varEnv}{a vector of environmental variances for one or more traits}

\item{meanDD}{mean dominance degree}

\item{varDD}{variance of dominance degree}

\item{corA}{a matrix of correlations between additive effects}

\item{corDD}{a matrix of correlations between dominance degrees}

\item{corGxE}{a matrix of correlations between GxE effects}

\item{useVarA}{tune according to additive genetic variance if true}

\item{gamma}{should a gamma distribution be used instead of normal}

\item{shape}{the shape parameter for the gamma distribution}

\item{force}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\description{
Randomly assigns eligble QTLs for a trait with dominance and GxE.
}
\section{Usage}{
 SP$addTraitADG(nQtlPerChr, mean = 0, var = 1, varGxE = 1e-6, 
varEnv = 0, meanDD = 0, varDD = 0, corA = NULL, corDD = NULL, 
corGxE = NULL, useVarA = TRUE, gamma = FALSE, shape = 1, force = FALSE)
}

\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitADG(10, meanDD=0.5, varGxE=2)

}
