% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam_setGender}
\alias{SimParam_setGender}
\title{Set gender in simulation}
\arguments{
\item{gender}{acceptable value are "no", "yes_sys", or 
"yes_rand"}

\item{force}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\description{
Changes how gender is used in the simulation. 
The default gender of a simulation is "no". To add gender 
to the simulation, run this function with "yes_sys" or 
"yes_rand". The value "yes_sys" will systematically assign 
gender to newly created individuals as first male, then female. 
Thus, odd numbers of individuals will have one more male than 
female. The value "yes_rand" will randomly assign gender to 
individuals.
}
\section{Usage}{
 SP$setGender(gender, force = FALSE)
}

\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$setGender("yes_sys")

}
