% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam_restrSegSites}
\alias{SimParam_restrSegSites}
\title{Restrict segregating sites}
\arguments{
\item{maxQtl}{the maximum number of segSites for QTLs. 
Can be a single value or a vector values for each 
chromosome.}

\item{maxSnp}{the maximum number of segSites for SNPs. 
Can be a single value or a vector values for each 
chromosome.}

\item{overlap}{should SNP and QTL sites be allowed to overlap.}

\item{minSnpFreq}{minimum allowable frequency for SNP loci. 
No minimum SNP frequency is used if value is NULL.}

\item{force}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\description{
Sets restrictions on which segregating sites 
can serve as SNP and/or QTL.
}
\section{Usage}{
 SP$restrSegSites(maxQtl = 0, maxSnp = 0, 
snpQtlOverlap = FALSE, minSnpFreq = NULL, force = FALSE)
}

\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$restrSegSites(maxQtl=5, maxSnp=5)

}
