% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-Pop.R
\name{newPop}
\alias{newPop}
\title{Create new population}
\usage{
newPop(rawPop, simParam = NULL, ...)
}
\arguments{
\item{rawPop}{an object of \code{\link{MapPop-class}} or 
\code{\link{NamedMapPop-class}}}

\item{simParam}{an object of \code{\link{SimParam}}}

\item{...}{additional arguments used internally}
}
\value{
Returns an object of \code{\link{Pop-class}}
}
\description{
Creates an initial \code{\link{Pop-class}} from an object of 
\code{\link{MapPop-class}} or \code{\link{NamedMapPop-class}}. 
The function is intended for us with output from functions such 
as \code{\link{runMacs}}, \code{\link{newMapPop}}, or 
\code{\link{quickHaplo}}.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=2, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)

}
