% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waic.R
\name{waic}
\alias{waic}
\title{WAIC calculator}
\usage{
waic(StanS4classwithTargetFormulation, dig = 4, summary = TRUE)
}
\arguments{
\item{StanS4classwithTargetFormulation}{This is a  S4 class built by \code{stan}
function in the \code{rstan} package.

In this package, we make a new S4 class which is inherited class of rstan's S4 class named "stanfit".
However this function can be available for stanfit S4 class.}

\item{dig}{The number of significant digits of waic.}

\item{summary}{TRUE or FALSE. If TRUE then summary and estimates are printed in the R console. If FALSE, the output is minimal.}
}
\value{
The output is the value of WAIC.
}
\description{
Using the S4 class by stan with \code{target += },
    we calculate the WAIC.
}
\examples{
\donttest{
#First, we prepare the data endowed with this package.

        dat  <- get(data("dataList.Chakra.1"))




#Second, we run the stan funtion
#with data named "dat"   via the author's Bayesian model.


            fit <- fit_Bayesian_FROC(dat, PreciseLogLikelihood = TRUE)


#Now, As a return from above,
#we get the rstan::stan's out put which is S4 class named "fit".


#Using the output "fit",



                 waic(fit)



#The Author provide two model for FROC for single reader and single modality case.
#One is false alarm rates means "per lesion" and the other means "per image".
#The above "fit" is "per image". Now we shall consider to compare these two model
#by WAIC. To do so, next we shall fit the "per lesion" model as follows:

fit2 <- fit_Bayesian_FROC(dat, PreciseLogLikelihood = TRUE, ModifiedPoisson=TRUE)

waic(fit2)



# By compare two model's WAIC we can say which model is better.
# Note that the smaller WAIC is better.

waic(fit) # per lesion model
waic(fit2) # per image model



}# dottest
}
