% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array_of_hit_and_false_alarms_from_vector.R
\name{array_of_hit_and_false_alarms_from_vector}
\alias{array_of_hit_and_false_alarms_from_vector}
\title{Array of hits and false alarms; 2019 Jun 18}
\usage{
array_of_hit_and_false_alarms_from_vector(dataList)
}
\arguments{
\item{dataList}{An list, should include  the following \R objects:\code{m,q,c,h,f,NL,C,M,Q} which means from the right

\code{m } means the modality ID vector

\code{q } means the reader ID vector

\code{c } means the confidence level

\code{h } means the number of hits

\code{f } means the number of false alarm

\code{NL } means the Total number of lesions for all images

\code{C } means the highest number of confidence level

\code{M } means the number of modalities

\code{Q } means the number of readers.

The detail of these dataset, please see the example datasets, e.g. \code{\link{dd}}.}
}
\value{
A list of array, contains  \code{h} and \code{f} of dimension \code{ [c,M,Q]}. Do not confuse \code{ [c,Q,M]} or \code{ [M,Q,C]}  or etc.
}
\description{
Return value is an array of type \strong{\emph{[C,M,Q]}} representing hit and false alarms.



Who read this ? I am not sure, who read but if someone,....who read and where I will go? I love you.
}
\details{
The author also implemented this in the \code{ \link{metadata_to_fit_MRMC}} which we shall  call old version.
However, old version use \code{for} sentence, and it is not so better.
On the other hand,
this function use
the function \code{\link[base]{aperm}}()
and   \code{\link[base]{array}}() and which is better than \code{for} sentence.
}
\examples{
#--------------------------------------------------------------------------------------
#                        Validation of program
#--------------------------------------------------------------------------------------


 h1 <- array_of_hit_and_false_alarms_from_vector(dd)$harray
 h2 <- metadata_to_fit_MRMC(dd)$harray

 h1 == h2




 f1 <- array_of_hit_and_false_alarms_from_vector(dd)$farray
 f2 <- metadata_to_fit_MRMC(dd)$farray

 f1 == f2

#--------------------------------------------------------------------------------------
#                       subtraction for ( hit - hit.expected)
#--------------------------------------------------------------------------------------
# Chi square calculation, we need to subtract expected value of hit from hit rate,
# thus the author made this function.


\donttest{


# Prepare data

    dd <- BayesianFROC::dd


# Fit a data


    fit <- fit_Bayesian_FROC(  dataList = dd )


# Extract a expected hits by array



    harray.expected  <-  extract_EAP_by_array(fit,ppp)*dd$NL



# Prepare hits data by array


     harray <- array_of_hit_and_false_alarms_from_vector(dd)$harray




# Calculate the difference of hits and its expectation..



 Difference <- harray - harray.expected


# Such calculation is required in the chi square goodness of fit


}


}
\seealso{
\code{ \link{Chi_square_goodness_of_fit_in_case_of_MRMC_Posterior_Mean}}
}
