% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawCurves.R
\name{DrawCurves}
\alias{DrawCurves}
\title{Draw the FROC  curves}
\usage{
DrawCurves(
  StanS4class,
  modalityID,
  readerID,
  title = TRUE,
  indexCFPCTP = FALSE,
  upper_x,
  upper_y,
  new.imaging.device = TRUE,
  Colour = TRUE,
  DrawFROCcurve = TRUE,
  DrawAFROCcurve = FALSE,
  DrawAUC = TRUE,
  DrawCFPCTP = TRUE,
  Draw.Flexible.upper_y = TRUE,
  Draw.Flexible.lower_y = TRUE,
  summary = TRUE,
  type = 4,
  color_is_changed_by_each_reader = FALSE,
  Draw.inner.circle.for.CFPCTPs = TRUE
)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{stanfit}.
This \R object is a fitted model object
 as a return value of the function \code{\link{fit_Bayesian_FROC}()}.

It can be passed to \code{\link{DrawCurves}()}, \code{\link{ppp}()}  and ... etc}

\item{modalityID}{A positive integer vector indicating modalityID. If it is not given, then the first modality is chosen.}

\item{readerID}{A positive integer vector indicating  readerID. If it is not given, then the first reader is chosen.}

\item{title}{Logical: \code{TRUE} of \code{FALSE}.  If \code{TRUE}  (default), then title of curves are drawn.}

\item{indexCFPCTP}{TRUE of FALSE. If TRUE, then the cumulative false and hits are specified with its confidence level.}

\item{upper_x}{This is a upper bound for the axis of the horisontal coordinate of FROC curve.}

\item{upper_y}{This is a upper bound for the axis of the vertical coordinate of FROC curve.}

\item{new.imaging.device}{Logical: \code{TRUE} of \code{FALSE}. If TRUE (default), then open a new device to draw curve.
Using this we can draw curves in same plain by new.imaging.device=FALSE.}

\item{Colour}{Logical: \code{TRUE} of \code{FALSE}.  whether Colour of curves is dark theme or not.}

\item{DrawFROCcurve}{Logical: \code{TRUE} of \code{FALSE}.  Whether or not FROC curves are shown.}

\item{DrawAFROCcurve}{Logical: \code{TRUE} of \code{FALSE}.  Whether or not AFROC curves are shown.}

\item{DrawAUC}{TRUE of FALSE. If TRUE then area under the  AFROC curves are painted.}

\item{DrawCFPCTP}{Logical: \code{TRUE} of \code{FALSE}.  Whether or not the pairs of \emph{FPF} and \emph{TPF} are shown.}

\item{Draw.Flexible.upper_y}{Logical: \code{TRUE} of \code{FALSE}.  Whether or not the upper bounds of vertical axis are determined automatically.}

\item{Draw.Flexible.lower_y}{Logical: \code{TRUE} of \code{FALSE}.  Whether or not the lower bounds of vertical axis are determined automatically.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary. If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}

\item{type}{An integer, for the color of background and etc.}

\item{color_is_changed_by_each_reader}{A logical, if \code{TRUE}, then the FROC curves, AFROC curves, and FPF, TPF are colored accordingly by each reader. The aim of FROC analysis is to compare the modality and not reader, so the default value is false, and curves and FPF and TPF are colored by each modalities.}

\item{Draw.inner.circle.for.CFPCTPs}{TRUE or FALSE. If true, then to plot the cumulative false positives and true positives the plot points is depicted by two way, one is a large circle and one is a small circle. By see the small circle, user can see the more precise position of these points.}
}
\description{
The function makes a plot of the FROC curve,  the AFROC curve and  \emph{FPF} and \emph{TPF}.
}
\details{
The function makes a plot of the FROC curves and AFROC curves for user's specified modality and user's specified reader.
Using this function \strong{repeatedly}, we can draw the different reader and modality in a  \strong{same} plane simultaneously.
So, we can visualize the difference of modality (reader).
}
\examples{
#================The first example======================================
\dontrun{
#1) Fit a model to data by the following:



  fit <- fit_Bayesian_FROC(
  BayesianFROC::dataList.Chakra.Web,    # data to which fit the model
                           ite=1111  # iteration of MCMC is too small
                           )

#Note that the return value "fit" is an object of an inherited S4 class from stanfit




#2)  Using the above S4 class object, we draw the curves.



          DrawCurves(
                    fit,
                    modality = 1,
                      reader = 4)

#From this code, an FROC curve for the first modality and the fourth reader is drawn.







#3) By changing, e.g., the modality,
   #we can draw the curves for different  modalities.
   #This shows the comparison of modalites.
   # In the following,
   # the first script plots a curve for the 2 nd modality and the fourth reader,
   # and the second script plots a curve for the 3rd modality and the 4 th reader,
   # respectively.



            DrawCurves(fit,modality = 2,reader = 4)
            DrawCurves(fit,modality = 3,reader = 4)



# Curves are overwritten in a single imaging device for the comparison.



#4) By applying the function with respect to different modalities
#   in this manner, we can draw  AFROC (FROC) curves in the same plain.



#5) If you want to draw the FROC curves
#for reader ID =1,2,3,4 and modality ID =1,2, then the code is as follows;

                  DrawCurves(
                            fit,
                            modalityID = c(1,2,3,4),
                            readerID   = c(1,2)
                            )
# Each color of curves corresponds to the modality ID.
# So, the curves of "different" readers will have the "same" color,
# if their modalities are "same".







# 6) To show only data points, i.e. FPF and TPF,
#    use DrawFROCcurve = F as follows;

DrawCurves(fit,
           DrawCFPCTP    = TRUE,   # This implies data points are ploted.
           DrawFROCcurve = FALSE,  # From this, the curves are not drawn.
           modalityID    = c(1,2,3,4),
           readerID      = c(1)
           )







#7) If you use the plot in submission and it is not allowed to use color, then
#   by Colour  = FALSE, you can get black and white plots, e.g.,


DrawCurves(fit,
          DrawCFPCTP    = TRUE,
          DrawFROCcurve = TRUE,
          modalityID    = c(1,2,3,4),
          readerID      = c(1),
          Colour = FALSE    # From this, you can get plots without colors.
          )







#8)  For AFROC, use DrawAFROCcurve = T

DrawCurves(fit,
          DrawFROCcurve  = FALSE,
          DrawAFROCcurve = TRUE,
          modalityID     = c(1,2,3,4),
          readerID       = c(1)
          )






#9)

# In order to compare modality, we draw curves by each modality
# The 1-st modality with all readers 1,2,3,4:


DrawCurves(fit,modalityID = 1,readerID = 1:4, new.imaging.device = TRUE)

#The 2-nd modality with all readers 1,2,3,4:
DrawCurves(fit,modalityID = 2,readerID = 1:4, new.imaging.device = FALSE)


#The 3-rd modality with all readers 1,2,3,4:
DrawCurves(fit,modalityID = 3,readerID = 1:4, new.imaging.device = FALSE)


#The 4-th modality with all readers 1,2,3,4:
DrawCurves(fit,modalityID = 4,readerID = 1:4, new.imaging.device = FALSE)


#The 5-th modality with all readers 1,2,3,4:
DrawCurves(fit,modalityID = 5,readerID = 1:4, new.imaging.device = FALSE)



# Draw for all pairs of modalities and readers:

            DrawCurves(
                        modalityID = 1:fit@dataList$M,
                          readerID = 1:fit@dataList$Q,
                       StanS4class = fit
                        )









# Changes the color by


                             DrawCurves(fit, type = 2)
                             DrawCurves(fit, type = 3)
                             DrawCurves(fit, type = 4)
                             DrawCurves(fit, type = 5)
                             DrawCurves(fit, type = 6)
                             DrawCurves(fit, type = 7)





#================The Second Example======================================================

# This function is available in the case of a single reader and a single modality.
# The reason why the maintainer separate the function for two processes, one is
# the fitting and the second is to plot curves is, in MRMC case,
# it tooks a time to drawing, but in the a single reader and a single modality case, drawing
# the curve is very fast, so in fitting process the curves are also depicted, however
# by this function user can draw the FROC curves.





#First, we prepare the data endowed with this package.





                          dat  <- get(data("dataList.Chakra.1"))




#Second, we fit a model to data named "dat"





                             fit <-  fit_srsc(dat)





# Drawing the curves by


                             DrawCurves(fit)






# Changes the color by


                             DrawCurves(fit, type = 2)
                             DrawCurves(fit, type = 3)
                             DrawCurves(fit, type = 4)
                             DrawCurves(fit, type = 5)
                             DrawCurves(fit, type = 6)
                             DrawCurves(fit, type = 7)

#      Close the graphic device to avoid errors in R CMD check.

         Close_all_graphic_devices()
}# dottest
}
