% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitPeakByIsotopicRatio.R
\name{FitPeakByIsotopicRatio}
\alias{FitPeakByIsotopicRatio}
\title{Extrapolate a flat top peak using isotopic ratios.}
\usage{
FitPeakByIsotopicRatio(cor_df = NULL, idx = NULL, silent = TRUE)
}
\arguments{
\item{cor_df}{A data frame containing information about the overloaded area; columns=(Scan, RT, mz0, int0, mz1, int1, mz2, int2, modified).}

\item{idx}{If not NULL, 'idx' is expected to specify points to correct explicitly (as a numeric-vector within 1:length(x)).}

\item{silent}{For testing purposes some QC-plot will be generated if silent=FALSE.}
}
\value{
An annotated plot of the mass spectrum and detailed information within the console.
Main result will be returned invisible.
}
\description{
\code{FitPeakByIsotopicRatio} will take a data frame containing peak data for retention time ('RT'), as well as
mass and intensity information of M0, M+1 and M+2 and extrapolate all points above a certain threshold for Int_M0
based on further parameters using an IsotopicRatio approach.
}
\details{
Isotopic ratios within ion traces of molecules can be considered stable. If this ratio is changed because one molecule,
let's say the M+0, is exceeding the detector range while another (say M+1) is still quantifiable, we therefore may
attempt to modify M+0 by multiplying the values of M+1 with a constant (the stable ratio). This constant is determined
ideally from the values within the peak front.
As this function is mainly used internally (\code{\link{CorrectOverloadedPeaks}}), it is not very flexible with respect
to the input format. Please prepare a dataframe according to the parameter specifications or process a file using
\code{\link{CorrectOverloadedPeaks}} with testing=TRUE, which will generate a list structure of such dataframes.
}
\examples{
# load test data
data("xcmsRaw_data")

# plot EIC for 350.165
par(mfrow=c(1,3))
#'\donttest{xcms::plotEIC(xcmsRaw_data, mzrange=matrix(c(350.16,350.17), nrow=1))}
# process example data with testing=TRUE for one individual peak to get the extracted data.frame
# necessary for FitPeakByIsotopicRatio
\donttest{CorrectOverloadedPeaks(data=xcmsRaw_data, method="Isoratio", testing=TRUE, region=4, peak=2)}
\donttest{load("cor_df_all.RData")}

# correct, plot and return reconstructed data
\donttest{FitPeakByIsotopicRatio(cor_df=cor_df_all[[4]][[2]], silent=FALSE)}

# plot (corrected) EIC for 350.165
\donttest{xcms::plotEIC(xcmsRaw_data, mzrange=matrix(c(350.16,350.17), nrow=1))}

}
