\name{whittermore.boot}

\alias{whittermore.boot}
\alias{whittermore.pboot}

\title{Generate bootstrap replicates of Whittermore's statistic}

\description{
Generate bootstrap replicates of Whittermore's statistic by means of function
\emph{boot} from \emph{boot} library. Notice that these functions should not
be used separately but as argument \emph{statistic} when calling function
\emph{boot}.

\emph{whittermore.boot} is used to perform a non-parametric bootstrap

\emph{whittermore.pboot} is used when using parametric bootstrap.
}


\usage{
whittermore.boot(data, i, ...)
whittermore.pboot(...)
}

\arguments{
\item{data}{A dataframe with the data as explained in \emph{DCluster}.}
\item{i}{Permutation generated by the non-parametric bootstrap procedure.}
\item{...}{Additional arguments passed when performing a bootstrap.}
}

\value{
Both functions return the value of the statistic.
}

\seealso{
DCluster, boot, whittermore, whittermore.stat
}

\examples{
library(boot)
library(spdep)

data(nc.sids)

sids<-data.frame(Observed=nc.sids$SID74)
sids<-cbind(sids, Expected=nc.sids$BIR74*sum(nc.sids$SID74)/sum(nc.sids$BIR74) )
sids<-cbind(sids, x=nc.sids$x, y=nc.sids$y)

#Calculate neighbours based on distance
coords<-as.matrix(sids[,c("x", "y")])

dlist<-dnearneigh(coords, 0, Inf)
dlist<-include.self(dlist)
dlist.d<-nbdists(dlist, coords)

#Calculate weights. They are globally standardised but it doesn't
#change significance.
col.W.whitt<-nb2listw(dlist, glist=dlist.d, style="C")

niter<-100

#Permutation model
wt.boot<-boot(sids, statistic=whittermore.boot, R=niter, listw=col.W.whitt,
	zero.policy=TRUE)
plot(wt.boot)#Display results

#Multinomial model
wt.mboot<-boot(sids, statistic=whittermore.pboot, sim="parametric", 
	ran.gen=multinom.sim,  R=niter,  listw=col.W.whitt, zero.policy=TRUE)
		
plot(wt.mboot)#Display results

#Poisson model
wt.pboot<-boot(sids, statistic=whittermore.pboot, sim="parametric", 
	ran.gen=poisson.sim,  R=niter,  listw=col.W.whitt, zero.policy=TRUE)
		
plot(wt.pboot)#Display results

#Poisson-Gamma model
wt.pgboot<-boot(sids, statistic=whittermore.pboot, sim="parametric", 
	ran.gen=negbin.sim, R=niter, listw=col.W.whitt, zero.policy=TRUE)
plot(wt.pgboot)#Display results
}

\references{
Whittermore, A. S. and Friend, N. and Byron, W. and Brown, J. R. and Holly, E. A. (1987). A test to detect clusters of disease. Biometrika 74, 631-635.
}


\keyword{spatial}
