% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{Gamma}
\alias{Gamma}
\title{Estimated Density Values by Gamma kernel}
\usage{
Gamma(y, k, h)
}
\arguments{
\item{y}{a numeric vector of positive values.}

\item{k}{gird points.}

\item{h}{the bandwidth}
}
\value{
\item{x}{grid points}
        \item{y}{estimated values of density}
}
\description{
Estimated Kernel density values by using Gamma Kernel.
}
\details{
The Gamma kernel is developed by Chen (2000). He was first to introduce asymetrical kernels to control boundary Bias.
Gamma Kernel is
\deqn{K_{Gam1( \frac{x}{h+1}, h)}(y) = \frac{y^ \frac{x}{h} exp(-\frac{y}{h})}{ \Gamma \frac{x}{(h+1)}h^{ \frac{x}{h+1}}}}
}
\examples{
y <- rexp(100,1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
Gamma(y,200,h)
}
\references{
Chen, S. X. 2000. Probability density function estimation using Gamma kernels.  \emph{Annals of the Institute of Statistical Mathematics} \strong{52} (3), 471-480.
}
\seealso{
For further kernels see \code{\link{Erlang}}, \code{\link{BS}} and \code{\link{LN}}. To plot its density see \code{\link{plot.Gamma}} and to calculate MSE by using Gamma Kernel \code{\link{mseGamma}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
