% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{dencomb}
\alias{dencomb}
\title{Plot the Densities for Comparison}
\usage{
dencomb(y, k, h, comb)
}
\arguments{
\item{y}{a numeric vector of positive values.}

\item{k}{gird points.}

\item{h}{the bandwidth}

\item{comb}{mention the combination which kernel estimated densities are to be compared. If Lognormal and Birnbaum-Saunders kernel densities
are to be compared along with real density then use \code{"TLB"}. If Lognormal and Erlang then use \code{"TLE"}. If Lognormal and Gamma to be compared
then use \code{"TLG"}. For Birnbaum-Saunders and Erlang use \code{"TBE"}. For Birnbaum-Saunders and Gamma then use \code{"TBG"}. For Erlang and Gamma use \code{"TEG"}.
For Lognormal, Birnbaum-Saunders and Erlang use \code{"TLBE"}. For Lognormal, Birnbaum-Saunders and Gamma use \code{"TLBG"}. For Birnbaum-Saunders, Erlang and Gamma
use \code{"TBEG"}. To compare all densities in one graph use \code{"TLBEG"}.}
}
\value{
Plot of Estimated Densities with Real Data Density.
}
\description{
Plot the Estimated Densities with Real Density for Comparison .
}
\examples{
\dontrun{
y <- rexp(10,1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
dencomb(y,20,h,"TLB")}
}
\references{
\itemize{
\item Jin, X.; Kawczak, J. 2003. Birnbaum-Saunders & Lognormal kernel estimators for modeling durations in high frequency financial data. \emph{Annals of Economics and Finance} \strong{4}, 103–124.
\item Salha, R. B.; Ahmed, E. S.; Alhoubi, I. M. 2014. Hazard rate function estimation ksing Erlang Kernel. \emph{Pure Mathematical Sciences} \strong{3} (4), 141–152.
\item Chen, S. X. 2000. Probability density function estimation using Gamma kernels.  \emph{Annals of the Institute of Statistical Mathematics} \strong{52} (3), 471-480.
}
}
\seealso{
For indivisual densities of each kernels see \code{\link{plot.Erlang}}, \code{\link{plot.BS}}, \code{\link{plot.LN}}, and \code{\link{plot.Gamma}}
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
