% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ParrConstraint}
\alias{ParrConstraint}
\title{2D constraint function}
\usage{
ParrConstraint(x)
}
\arguments{
\item{x}{a 2-dimensional vector or a two-column matrix specifying the location(s) where the function
is to be evaluated.}
}
\value{
A scalar
}
\description{
Strongly multimdoal constraint function from Parr et al. (standardized version)
}
\examples{
n.grid <- 20
x.grid <- y.grid <- seq(0,1,length=n.grid)
design.grid <- expand.grid(x.grid, y.grid)
response.grid <- apply(design.grid, 1, ParrConstraint)
z.grid <- matrix(response.grid, n.grid, n.grid)
contour(x.grid,y.grid,z.grid,40)
title("Parr constraint function")
}

