% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EGA.fit.R
\name{EGA.fit}
\alias{EGA.fit}
\title{\code{\link[EGAnet]{EGA}} Optimal Model Fit using \code{\link[EGAnet]{entropyFit}}}
\usage{
EGA.fit(data, model = c("glasso", "TMFG"), steps = c(3, 4, 5, 6, 7, 8))
}
\arguments{
\item{data}{A dataset}

\item{model}{Character. 
A string indicating the method to use.
Defaults to \code{"glasso"}.

Current options are:

\itemize{

\item{\strong{\code{"glasso"}}}
{Estimates the Gaussian graphical model using graphical LASSO with
extended Bayesian information criterion to select optimal regularization parameter.
See \code{\link[EGAnet]{EBICglasso.qgraph}}}

\item{\strong{\code{"TMFG"}}}
{Estimates a Triangulated Maximally Filtered Graph.
See \code{\link[NetworkToolbox]{TMFG}}}

}}

\item{steps}{Numeric vector.
Range of steps to be used in the model selection.
Defaults from 3 to 8 steps (based on Pons & Latapy, 2006)}
}
\value{
Returns a list containing:

\item{EGA}{The \code{\link[EGAnet]{EGA}} output for the best fitting model}

\item{steps}{The number of steps used in the best fitting model from
the \code{\link[igraph]{cluster_walktrap}} algorithm}

\item{EntropyFit}{The \code{\link[EGAnet]{tefi}} Index for the unique solutions given the range of steps
(vector names represent the number of steps)}

\item{Lowest.EntropyFit}{The lowest value for the \code{\link[EGAnet]{entropyFit}} Index}
}
\description{
Estimates the best fitting model using \code{\link[EGAnet]{EGA}}.
The number of steps in the \code{\link[igraph]{cluster_walktrap}} detection
algorithm is varied and unique community solutions are compared using
\code{\link[EGAnet]{entropyFit}}.
}
\examples{

# Load data
wmt <- wmt2[,7:24]

\dontrun{
# Estimate normal EGAtmfg
tmfg <- EGA(data = wmt, model = "TMFG")

# Estimate optimal EGAtmfg
tmfg.opt <- EGA.fit(data = wmt, model = "TMFG")

# Compare with CFA
cfa.tmfg <- CFA(tmfg, estimator = "WLSMV", data = wmt)
cfa.opt <- CFA(tmfg.opt$EGA, estimator = "WLSMV", data = wmt)

lavaan::lavTestLRT(cfa.tmfg$fit, cfa.opt$fit, method = "satorra.bentler.2001")

}

}
\references{
Pons, P., & Latapy, M. (2006).
Computing communities in large networks using random walks.
\emph{Journal of Graph Algorithms and Applications}, \emph{10}, 191-218.
doi:\href{https://doi.org/10.7155/jgaa.00185}{10.7155/jgaa.00185}
}
\seealso{
\code{\link[EGAnet]{bootEGA}} to investigate the stability of EGA's estimation via bootstrap,
\code{\link[EGAnet]{EGA}} to estimate the number of dimensions of an instrument using EGA,
and \code{\link[EGAnet]{CFA}} to verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
