% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserFunctions.R
\name{setSelectOnInds}
\alias{setSelectOnInds}
\title{Setting the selection on individuals}
\usage{
setSelectOnInds(
  genomeObj = NULL,
  indFit = c(),
  femaleFit = c(),
  maleFit = c(),
  selectionObj = NULL
)
}
\arguments{
\item{genomeObj}{a \code{Genome} object}

\item{indFit}{a genotypic fitness vector for all individuals (whether or not
they are hermaphordite)}

\item{femaleFit}{a genotypic fitness vector for females only (only if the
population is dioecious)}

\item{maleFit}{a genotypic fitness vector for males only (only if the
population is dioecious)}

\item{selectionObj}{a \code{Selection} object (in the case where the
selection on individuals is overlaid on an existing \code{Selection} object)}
}
\value{
a \code{Selection} object
}
\description{
Generation of an object of the \code{Selection} class which defines a
selection among the individuals either by adding this type of selection
to an already existing \code{SelectionObj} object (parameter
\code{selectionObj}) or by creating one.
}
\examples{
LD <- list(dl = as.factor(c("A", "a")))
HL <- list(hl = as.factor(c("B", "b")))
genomeObj <- setGenome(listHapLoci = HL, listDipLoci = LD)
selectionObj <- setSelectOnInds(
  genomeObj = genomeObj,
  indFit = c(1, 1, 1, 1, 0.5, 0)
)

}
\author{
Ehouarn Le Faou
}
