% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FORCE.R
\name{gforce.PECOK}
\alias{gforce.PECOK}
\title{Solve PECOK with FORCE.}
\usage{
gforce.PECOK(K, X = NULL, D = NULL, sigma_hat = NULL, force_opts = NULL,
  X0 = NULL, E = NULL, gamma_par = FALSE)
}
\arguments{
\item{K}{number of clusters.}

\item{X}{\eqn{n x d} matrix. Either this or \code{D} must be specified.}

\item{D}{\eqn{d x d} matrix. Either this or \code{X} must be specified.}

\item{sigma_hat}{\eqn{d x d} matrix. If \code{D} is specified, this argument should be the
estimated covariance matrix. It is not strictly necessary to provide it, but it should be for
optimal performance. If \code{X} is specified, it will be ignored.}

\item{force_opts}{tuning parameters. \code{NULL} signifies defaults will be used.}

\item{X0}{initial iterate. \code{NULL} signifies that it will be generated randomly from \code{D_Kmeans}. If supplied, \code{E} must be supplied as well.}

\item{E}{strictly feasible solutions. \code{NULL} signifies that it will be generated randomly. If supplied, \code{X0} must be supplied as well.}

\item{gamma_par}{logical expression. If \code{gamma_par==TRUE}, then if \eqn{\Gamma} is computed,
a multi-threaded method is called, otherwise a single-threaded method is called.}
}
\description{
Uses the FORCE algorithm to solve the PECOK SDP.
}
\references{
C. Eisenach and H. Liu. Efficient, Certifiably Optimal High-Dimensional Clustering. \emph{arXiv:1806.00530}, 2018.

J. Peng and Y. Wei. Approximating K-means-type Clustering via Semidefinite Programming. \emph{SIAM Journal on Optimization}, 2007.

F. Bunea, C. Giraud, M. Royer and N. Verzelen. PECOK: a convex optimization approach to variable clustering. \emph{arXiv:1606.05100}, 2016.
}
\seealso{
\code{\link{gforce.defaults}}
}
