% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdat.R
\name{get_hurdat}
\alias{get_hurdat}
\title{Get HURDAT and parse to dataframe}
\usage{
get_hurdat(basin = c("AL", "EP"))
}
\arguments{
\item{basin}{AL or EP. Default is both.}
}
\description{
Retrieve Raw HURDAT files for Atlantic (AL), northeast and central Pacific
  (EP) basins (northwestern hemisphere)
}
\details{
Raw text files \emph{should} be found at
  \url{http://www.nhc.noaa.gov/data/hurdat/} as of this writing. The
 codebooks are listed below.
}
\examples{
\dontrun{
# Get Atlantic storms
al <- get_hurdat(basin = "AL")

# Get northeast and north-central Pacific storms.
ep <- get_hurdat(basin = "EP")

# Get all storms
df <- get_hurdat()
}
}
\seealso{
Atlantic codebook:
    \url{http://www.nhc.noaa.gov/data/hurdat/hurdat2-format-atlantic.pdf}

NE/NC Pacific codebook:
    \url{http://www.nhc.noaa.gov/data/hurdat/hurdat2-format-atlantic.pdf}
}
