% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernelspec.R
\name{installJuniper}
\alias{installJuniper}
\title{Install the Juniper Kernel for Jupyter}
\usage{
installJuniper(useJupyterDefault = FALSE, kernelName = defaultKernelName(),
  displayName = defaultDisplayName(), prefix = "")
}
\arguments{
\item{useJupyterDefault}{If \code{TRUE}, install the kernel in a default Jupyter kernel location fashion. For macOS,
the default Jupyter kernel location is \code{~/Library/Jupyter/kernels}. For Windows, the
default Jupyter kernel location is \code{\%APPDATA\%\\jupyter\\kernels}. For Linux this directory is
\code{~/.local/share/jupyter/kernels}.
If \code{FALSE}, the kernel is installed system-wide. For unix-based machines,
the system-level directory is \code{/usr/share/jupyter/kernels} or
\code{/usr/local/share/jupyter/kernels}. For Windows, the location is
\code{\%PROGRAMDATA\%\\jupyter\\kernels}.
If the \code{prefix} argument is specified, then the \code{useJupyterDefault} parameter is ignored.}

\item{kernelName}{A character string representing the location of the kernel. This is required
to be made up of alphanumeric and \code{.}, \code{_}, \code{-} characters only.
This is enforced with a check against this \code{^[a-zA-Z_][a-zA-Z0-9_.-]*$} regex.
The case of this argument is always ignored and is \code{tolower}ed; so while it's
allowed to have mixed-case characters, the resulting location will not be. A warning
will be issued if there is mixed-case characters. The default for this
\code{juniper_r} concatenated with the \code{major.minor} version of R. For example,
for R 3.4.0, the default would be \code{juniper_r3.4.0}.}

\item{displayName}{A character string representing the name of the kernel in a client. There are no
restrictions on the display name. The default for R 3.4.0 is \code{R 3.4.0 (Juniper)}.}

\item{prefix}{A character string specifying the \code{virtual env} that this kernel should be installed
to. The install location will be \code{prefix/share/jupyter/kernels}.}
}
\description{
Install Juniper Kernel
}
\details{
Use this method to install the Juniper Kernel. After a successful invocation
of this method, Juniper will be an available kernel for all Jupyter front-end
clients (e.g., the dropdown selector in the Notebook interface). This method
is essentially a wrapper on the function call \code{jupyter kernelspec install}
with some extra configuration options. These options are detailed as the parameters
below. One important note to make is that the kernel will depend the \code{R} environment
that doing the invoking. In this way a user may install kernels for different versions
of R by invoking this \code{installJuniper} method from each respective R. The defaults
for \code{kernelName} and \code{displayName} are good for avoiding namespacing issues
between versions of R, but installs having the same kernel name replace an existing
kernel.
}
\examples{
\dontrun{
  installJuniper(useJupyterDefault = TRUE)  # install into default Jupyter kernel location
}
}
