% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODIStsp_vrt_create.R
\name{MODIStsp_vrt_create}
\alias{MODIStsp_vrt_create}
\title{Create MODIStsp virtual files}
\usage{
MODIStsp_vrt_create(
  sensor,
  out_prod_folder,
  bandnames,
  bandsel,
  nodata_out,
  indexes_bandnames,
  indexes_bandsel,
  indexes_nodata_out,
  quality_bandnames,
  quality_bandsel,
  quality_nodata_out,
  file_prefixes,
  ts_format,
  out_format,
  verbose
)
}
\arguments{
\item{sensor}{\code{character ["Terra"| "Aqua" | "Both"]} MODIS platform to be considered.
(Ignored for MCD* products).}

\item{out_prod_folder}{\code{character} Main output folder.}

\item{bandnames}{\verb{character array} Abbreviated Names of original layers of the
selected product (used to build output file names).}

\item{bandsel}{\verb{integer 0/1 array} of length equal to number of original
layers of the selected product set to 1 for bands to be processed.}

\item{nodata_out}{\verb{numeric array} Target NoData values of MODIS original layers
(Ignored if nodata_change == FALSE).}

\item{indexes_bandnames}{\verb{character array} Abbreviated Names of SIs available
for the selected product (used to build output file names of SIs).}

\item{indexes_bandsel}{\verb{integer 0/1 array} array of length equal to the number
of Spectral Indexes available for the product (standard + user-provided),
set to  1 for indexes to be processed.}

\item{indexes_nodata_out}{\verb{numeric array} NoData values to be used for SIs}

\item{quality_bandnames}{\verb{character array} Abbreviated Names of Quality
Indicators available for the selected product (used to build output file
names of QIs).}

\item{quality_bandsel}{\verb{integer 0|1 array} array of length equal to number
of available QIs, set to  1 for indexes to be processed.}

\item{quality_nodata_out}{\code{integer} Always set to 255.}

\item{file_prefixes}{\verb{character array (2)} file_prefixes for TERRA and AQUA -
used to identify the files corresponding to each sensor}

\item{ts_format}{\code{character ["ENVI" | "GDAL" | "Both"]} Required output format
for virtual file.}

\item{out_format}{\code{character ["ENVI" | "GTiff"]} Format of images used as
"input" for the vrt and contained in out_prod_folder/band folders.}

\item{verbose}{\code{logical} If FALSE, suppress processing messages, Default: TRUE}
}
\value{
NULL -
}
\description{
Function used to create virtual files from time series of single-band
files corresponding to different acquisition dates. The function takes as input
the folder in which the single-band files are stored, and creates a ENVI Meta
file and/or a GDAL vrt file that allows access to the full time series as if
it was a single physical file.
Created virtual files are stored in the "Time Series" subfolder of `out_prod_folder``
}
\note{
License: GPL 3.0
}
\author{
Lorenzo Busetto, phD (2014-2017) \email{lbusett@gmail.com}

Luigi Ranghetti, phD (2015) \email{ranghetti.l@irea.cnr.it}
}
